<?php
/**
 *	...
 *
 *	Copyright (c) 2010-2020 Christian Würker (ceusmedia.de)
 *
 *	This program is free software: you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation, either version 3 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *	@category		Library
 *	@package		CeusMedia_Common_UI_HTML_CSS
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@copyright		2010-2020 Christian Würker
 *	@license		http://www.gnu.org/licenses/gpl-3.0.txt GPL 3
 *	@link			https://github.com/CeusMedia/Common
 *	@since			0.6.8
 */
/**
 *	...
 *
 *	@category		Library
 *	@package		CeusMedia_Common_UI_HTML_CSS
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@copyright		2010-2020 Christian Würker
 *	@license		http://www.gnu.org/licenses/gpl-3.0.txt GPL 3
 *	@link			https://github.com/CeusMedia/Common
 *	@since			0.6.8
 */
class UI_HTML_CSS_LanguageSwitch
{
	protected $languages	= array();

	public function build( $currentLanguage )
	{
		$list	= new ADT_Tree_Menu_List();
		$icon	= self::getFlag( $currentLanguage );
		$label	= $this->languages[$currentLanguage];
		$span	= UI_HTML_Tag::create( "span", $icon, array( 'class' => "flagIcon" ) );
		$main	= new ADT_Tree_Menu_Item( "#", $span.$label );
		$list->addChild( $main );

		foreach( $this->languages as $languageKey => $languageLabel )
		{
			if( $languageKey == $currentLanguage )
				continue;
			$icon	= self::getFlag( $languageKey );
			$span	= UI_HTML_Tag::create( "span", $icon, array( 'class' => "flagIcon" ) );
			$item	= new ADT_Tree_Menu_Item( "?language=".$languageKey, $span.$languageLabel );
			$main->addChild( $item );
		}
		$code	= UI_HTML_Tree_Menu::buildMenu( $list );
		$code	= UI_HTML_Tag::create( "span", $code, array( 'class' => "menu select" ) );
		return $code;
	}

	protected static function getFlag( $isoCode )
	{
		return UI_HTML_CountryFlagIcon::build( $isoCode );
	}

	public function setLanguages( $array )
	{
		$this->languages	= $array;
	}
}
