<?php
/**
 *	TestUnit of UI_HTML_Panel.
 *	@package		Tests.
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@since			07.09.2008
 *	@version		0.1
 */
declare( strict_types = 1 );

use PHPUnit\Framework\TestCase;

/**
 *	TestUnit of UI_HTML_Panel.
 *	@package		Tests.
 *	@extends		Test_Case
 *	@uses			UI_HTML_Panel
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@since			07.09.2008
 *	@version		0.1
 */
class Test_UI_HTML_PanelTest extends Test_Case
{
	/**
	 *	Setup for every Test.
	 *	@access		public
	 *	@return		void
	 */
	public function setUp(): void
	{
	}

	/**
	 *	Cleanup after every Test.
	 *	@access		public
	 *	@return		void
	 */
	public function tearDown(): void
	{
	}

	/**
	 *	Tests Method 'build'.
	 *	@access		public
	 *	@return		void
	 */
	public function testBuild1()
	{
		$panel		= new UI_HTML_Panel();
		$assertion	= '<div id="a1" class="panel default"><div class="panelContent"><div class="panelContentInner"></div></div></div>';
		$creation	= $panel->build( "a1" );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'build'.
	 *	@access		public
	 *	@return		void
	 */
	public function testBuild2()
	{
		$panel		= new UI_HTML_Panel();
		$panel->setHeader( "header1" );
		$panel->setFooter( "footer1" );
		$panel->setContent( "content1" );
		$assertion	= '<div id="a1" class="panel default"><div class="panelHead"><div class="panelHeadInner">header1</div></div><div class="panelContent"><div class="panelContentInner">content1</div></div><div class="panelFoot"><div class="panelFootInner">footer1</div></div></div>';
		$creation	= $panel->build( "a1" );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'create'.
	 *	@access		public
	 *	@return		void
	 */
	public function testCreate1()
	{
		$assertion	= '<div id="a1" class="panel default"><div class="panelContent"><div class="panelContentInner"></div></div></div>';
		$creation	= UI_HTML_Panel::create( "a1", NULL, NULL );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'create'.
	 *	@access		public
	 *	@return		void
	 */
	public function testCreate2()
	{
		$assertion	= '<div id="a1" class="panel default"><div class="panelHead"><div class="panelHeadInner">header1</div></div><div class="panelContent"><div class="panelContentInner">content1</div></div><div class="panelFoot"><div class="panelFootInner">footer1</div></div></div>';
		$creation	= UI_HTML_Panel::create( "a1", "content1", "header1", NULL, "footer1" );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'setContent'.
	 *	@access		public
	 *	@return		void
	 */
	public function testSetContent()
	{
		$panel		= new Test_UI_HTML_PanelInstance();

		$panel->setContent( "1" );
		$assertion	= "1";
		$creation	= $panel->getProtectedVar( 'content' );
		$this->assertEquals( $assertion, $creation );

		$panel->setContent( "a2" );
		$assertion	= "a2";
		$creation	= $panel->getProtectedVar( 'content' );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'setContent'.
	 *	@access		public
	 *	@return		void
	 */
	public function testSetHeader()
	{
		$panel		= new Test_UI_HTML_PanelInstance();

		$panel->setHeader( "1" );
		$assertion	= "1";
		$creation	= $panel->getProtectedVar( 'header' );
		$this->assertEquals( $assertion, $creation );

		$panel->setHeader( "a2" );
		$assertion	= "a2";
		$creation	= $panel->getProtectedVar( 'header' );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'setFooter'.
	 *	@access		public
	 *	@return		void
	 */
	public function testSetFooter()
	{
		$panel		= new Test_UI_HTML_PanelInstance();

		$panel->setFooter( "1" );
		$assertion	= "1";
		$creation	= $panel->getProtectedVar( 'footer' );
		$this->assertEquals( $assertion, $creation );

		$panel->setFooter( "a2" );
		$assertion	= "a2";
		$creation	= $panel->getProtectedVar( 'footer' );
		$this->assertEquals( $assertion, $creation );
	}
}
class Test_UI_HTML_PanelInstance extends UI_HTML_Panel
{
	public function getProtectedVar( $varName )
	{
		if( !in_array( $varName, array_keys( get_object_vars( $this ) ) ) )
			throw new Exception( 'Var "'.$varName.'" is not declared.' );
		return $this->$varName;
	}
}
