<?php
/**
 *	TestUnit of Alg_Text_TermExtractor.
 *	@package		Tests.alg
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@since			22.12.2008
 *	@version		0.1
 */
declare( strict_types = 1 );

use PHPUnit\Framework\TestCase;

/**
 *	TestUnit of Alg_Text_TermExtractor.
 *	@package		Tests.alg
 *	@extends		Test_Case
 *	@uses			Alg_Text_TermExtractor
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@since			22.12.2008
 *	@version		0.1
 */
class Test_Alg_Text_TermExtractorTest extends Test_Case
{
	/**
	 *	Setup for every Test.
	 *	@access		public
	 *	@return		void
	 */
	public function setUp(): void
	{
		$this->path		= dirname( __FILE__ )."/";
		$this->text		= file_get_contents( $this->path."TermExtractorText.txt" );
		$this->black	= $this->path."TermExtractorBlacklist.list";
		$this->terms1	= parse_ini_file( $this->path."TermExtractorTerms1.ini" );
		$this->terms2	= parse_ini_file( $this->path."TermExtractorTerms2.ini" );

		foreach( $this->terms1 as $key => $value )
			$this->terms1[$key] = (int) $value;
		foreach( $this->terms2 as $key => $value )
			$this->terms2[$key] = (int) $value;
	}

	/**
	 *	Cleanup after every Test.
	 *	@access		public
	 *	@return		void
	 */
	public function tearDown(): void
	{
	}

	/**
	 *	Tests Method 'getTerms'.
	 *	@access		public
	 *	@return		void
	 */
	public function testGetTerms1()
	{
		$text	= "aa bb bb cc cc cc";
		$assertion	= array(
			"aa"	=> 1,
			"bb"	=> 2,
			"cc"	=> 3
		);
		$creation	= Alg_Text_TermExtractor::getTerms( $text );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'getTerms'.
	 *	@access		public
	 *	@return		void
	 */
	public function testGetTerms2()
	{
		$assertion	= $this->terms1;
		$creation	= Alg_Text_TermExtractor::getTerms( $this->text );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'getTerms'.
	 *	@access		public
	 *	@return		void
	 */
	public function testGetTerms3()
	{
		Alg_Text_TermExtractor::loadBlackList( $this->black );
		$assertion	= $this->terms2;
		$creation	= Alg_Text_TermExtractor::getTerms( $this->text );
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'loadBlacklist'.
	 *	@access		public
	 *	@return		void
	 */
	public function testLoadBlacklist()
	{
		$assertion	= explode( "\n", file_get_contents( $this->black ) );
		Alg_Text_TermExtractor::loadBlacklist( $this->black );
		$creation	= Alg_Text_TermExtractor::$blacklist;
		$this->assertEquals( $assertion, $creation );
	}

	/**
	 *	Tests Method 'setBlacklist'.
	 *	@access		public
	 *	@return		void
	 */
	public function testSetBlacklist()
	{
		$list		= array( "a", "b", "b" );

		$assertion	= array_unique( $list );
		Alg_Text_TermExtractor::setBlacklist( $list );
		$creation	= Alg_Text_TermExtractor::$blacklist;
		$this->assertEquals( $assertion, $creation );
	}
}
