/**
 *	jQuery Plugin to filter Packages and Classes in a Tree generated by DocCreater (theme:cm1).
 *	Needs plugin cmExpr.containsIgnoreCase.
 *	@name		cmDocTreeSearc
 *	@type		jQuery
 *	@cat		Plugins/UI
 *	@author		Christian Würker <Christian.Wuerker@CeuS-Media.de>
 *	@copyright	2009 Christian Würker <Christian.Wuerker@CeuS-Media.de> (http://ceus-media.de)
 *	@license	LGPL/CC
 *	@param		Object		settings (optional) 	Customize behaviour or Search Plugin
 */(function($){
  jQuery.fn.cmDocTreeSearch = function(settings){
    var container = this;
    settings = jQuery.extend({
      selectorTree  : "#tree",
      selectorInput : "#tree-query",
      hilightQuery  : false,
      classHilight  : "hilight"
    },settings);

    var tree = $(settings.selectorTree);															//  shortcut Tree Node
    var lastQuery = "";																				//  we'll store the last value of Query Input Field to avoid senseless UI updates

    $("li",tree).bind('hilightQuery',function(){													//  bind Event Handler to hilight searched Strings in Package and Class List Item Names
      query=$(settings.selectorInput).val();														//  get current Query String
      label=$(">span>a",this);																		//  get Label of List Item
      value=label.html();																			//  get HTML Content of Label
      exp=new RegExp( "("+query+")", "gi" );														//  create new RegExp with Query String
      value=value.replace(exp,'<b class="'+settings.classHilight+'">$1</b>');						//  replace Matches with Hilight Code
      label.html(value);																			//  write back Label Content
    });

    $("li",tree).bind('unhilight',function(){														//  bind Event Handler to remove set Hilight (can only be one)
      label=$(">span>a",this);																		//  get Label of List Item
      value=label.html();																			//  get HTML Content of Label
      exp=new RegExp("<[^>]+>([^<]+)<\/[^>]+>","g");												//  create new RegExp for Hilight HTML Tag
      value=value.replace(exp,"$1");																//  remove Hilight HTML Tag
      label.html(value);																			//  write back Label Content
    });

    $("li",tree).bind('enablePath',function(){														//  bind Event Handler to show found Classes and their Packages
      $(this).show();																				//  show current Class or Package
      $(this).parent().parent().filter(".package:hidden").trigger('enablePath');					//  find hidden Package Parents and trigger Event again
    });

    $("li",tree).bind('disablePath',function(){														//  bind Event Handler to hide ... @todo finish
      query=$(settings.selectorInput).val();
      $(this).hide();
      grand=$(this).parent().parent().filter(".package:visible");
      var contains = $(">span>a:containsIgnoreCase('"+query+"')",grand).size()>0;
      var hasVisChild=$("li.class",grand).filter(":visible").size();
      if(!contains&&!hasVisChild)
        grand.trigger('disablePath');
    });

    $(settings.selectorInput).keyup(function(){
      var query=$(this).val();
      if(query==lastQuery)
        return;
      lastQuery=query;
      $("li",tree).trigger('unhilight');
      $(".msgTreeEmpty",settings.selectorTree).hide();
      if(query){
        $("li.class",tree).each(function(){
          var contains = $(">span>a:containsIgnoreCase('"+query+"')",this).size()>0;
          var isVisible = $(this).filter(":visible").size()>0;
          if(contains&&!isVisible)
            $(this).trigger('enablePath');
          else if(!contains&&isVisible)
            $(this).trigger('disablePath');
          if(contains&&settings.hilightQuery)
            $(this).trigger('hilightQuery');
        });
      }
      else
      {
        $("li",tree).show();
        $("li",tree).show();
      }
      if(!$("li:visible",settings.selectorTree).size())
        $(".msgTreeEmpty",settings.selectorTree).show();
    });
    $(settings.selectorInput).trigger('keyup').focus();
  }
})(jQuery);