
**Welcome to DocCreator API reference demonstrating DocCreator itself on itself!**

Here you can see, what and how a code documentation, generated by DocCreator, would or could look like.


##### Example configuration

To apply DocCreator to your project save this configuration to <code>doc.xml</code>:

	<?xml version="1.0"?>
	<config>

		<!--  PROJECT SETTINGS  -->
		<project>
			<name>My Project</name>
			<path>[/path/to/project/]</path>
			<extension>php</extension>
			<ignore type="file">/^(_|[a-z])/</ignore>
			<ignore type="folder">#(doc|lib|test|vendor)/#</ignore>
			<category by="default">Project</category>
			<package by="default">MyProject</package>
		</project>

		<!--  BUILDER SETTINGS  -->
		<builder format="HTML" theme="Default">
			<path type="target" alt="must be absolute">doc/API/</path>
			<path type="documents" alt="must be absolute">doc/</path>
			<title version="x.y.z">My Project</title>
			<author email="john.doe@example.org">John Doe</author>
			<company url="example.org">Example Ltd.</company>
			<logo href="http://example.org/MyProject" title="MyProject @ Example">logo/book_64.png</logo>
			<language timezone="Europe/London">en</language>
			<option name="showSourceCode">1</option>
			<plugin>Home</plugin>
			<plugin>ClassList</plugin>
			<plugin>ParseErrors</plugin>
			<plugin>License</plugin>
		</builder>

		<!--  READER PLUGINS  -->
		<reader>
			<plugin>Relations</plugin>
			<plugin>Primitives</plugin>
		</reader>

		<!--  CORE SETTINGS  -->
		<creator>
			<limit name="time" title="max time to execute in seconds">60</limit>
			<path name="temp" hint="absolute or relative to work dir" title="path to store temporary files in">/tmp/</path>
			<path name="log" hint="absolute or relative to work dir" title="path to store log files in">/tmp/</path>
			<file name="serial" alt="absolute or relative to work dir">DocCreator.MyProject.serial</file>
			<file name="archive" alt="absolute or relative to work dir">DocCreator.MyProject.serial.gz</file>
			<file name="errors">doc-creator.error.log</file>
			<verbose general="TRUE" skip="TRUE" config="TRUE" info="TRUE" trace="TRUE"/>
		</creator>
	</config>

##### Running DocCreator

	php /path/to/DocCreator/doc.php --config-file=doc.xml
