<?php

use CeusMedia\Common\FS\Folder\Editor as FolderEditor;
use CeusMedia\Common\UI\Image;
use CeusMedia\Common\UI\Image\Processing as ImageProcessing;
use CeusMedia\HydrogenFramework\Controller;

class Controller_Manage_Company extends Controller
{
	protected $frontend;
	protected $messenger;
	protected $modelCompany;
	protected $request;

	public function activate( $companyId )
	{
		$company	= $this->checkCompany( $companyId );
		$this->modelCompany->edit( $companyId, [
			'status'		=> 2,
			'modifiedAt'	=> time()
		] );
		$this->messenger->noteSuccess( 'Unternehmen "'.$company->title.'" aktiviert.' );
		$this->restart( './manage/company' );
	}

	public function add()
	{
		$words		= (object) $this->getWords( 'add' );
		$data		= $this->request->getAllFromSource( 'POST' );

		if( $this->request->has( 'save' ) ){
			if( empty( $data['title'] ) )
				$this->messenger->noteError( $words->msgNoTitle );
			else if( $this->modelCompany->getAll( ['title' => $data['title']] ) )
				$this->messenger->noteError( $words->msgTitleExisting, $data['title'] );
			if( empty( $data['city'] ) )
				$this->messenger->noteError( $words->msgNoCity );
			if( empty( $data['postcode'] ) )
				$this->messenger->noteError( $words->msgNoPostcode );
			if( empty( $data['street'] ) )
				$this->messenger->noteError( $words->msgNoStreet );
			if( empty( $data['number'] ) )
				$this->messenger->noteError( $words->msgNoNumber );

			if( !$this->messenger->gotError() ){
				$data['createdAt']	= time();
				$companyId	= $this->modelCompany->add( $data );
				$this->messenger->noteSuccess( $words->msgSuccess, $data['title'] );
				$this->restart( 'edit/'.$companyId, TRUE );
			}
		}
		$data	= new stdClass();
		foreach( $this->modelCompany->getColumns() as $column )
			$data->$column	= htmlentities ( $this->request->get( $column ) );
		$this->view->addData( 'company', $data );
	}

	public function deactivate( $companyId )
	{
		$company	= $this->checkCompany( $companyId );
		$this->modelCompany->edit( $companyId, [
			'status'	=> -2,
			'modifiedAt' => time()
		] );
		$this->messenger->noteSuccess( 'Unternehmen "'.$company->title.'" deaktiviert.' );
		$this->restart( './manage/company' );
	}

	public function edit( $companyId )
	{
		$title			= $this->request->get( 'title' );
		$words			= (object) $this->getWords( 'edit' );
		$modelUser		= new Model_User( $this->env );
		$data		= $this->request->getAllFromSource( 'POST' );
		if( $this->request->has( 'save' ) ){
			if( empty( $data['title'] ) )
				$this->messenger->noteError( $words->msgNoTitle );
			else if( $this->modelCompany->getAll( ['title' => $data['title'], 'companyId' => '!= '.$companyId] ) )
				$this->messenger->noteError( $words->msgTitleExisting, $data['title'] );
			if( empty( $data['city'] ) )
				$this->messenger->noteError( $words->msgNoCity );
			if( empty( $data['postcode'] ) )
				$this->messenger->noteError( $words->msgNoPostcode );
			if( empty( $data['street'] ) )
				$this->messenger->noteError( $words->msgNoStreet );
			if( empty( $data['number'] ) )
				$this->messenger->noteError( $words->msgNoNumber );

			if( !$this->messenger->gotError() ){
				$data['modifiedAt']	= time();
				$this->modelCompany->edit( $companyId, $data );
				$this->messenger->noteSuccess( $words->msgSuccess, $data['title'] );
				$this->restart( './manage/company' );
			}
		}
		$company		= $this->modelCompany->get( $companyId );
		$branches		= [];
		$modelBranch	= new Model_Branch( $this->env );
		$branches		= $modelBranch->getAllByIndex( 'companyId', $companyId, ['title' => 'ASC'] );
		$company->branches	= $branches;
		$users		= [];
		if( in_array( 'companyId', $modelUser->getColumns() ) )
			$users	= $modelUser->getAllByIndex( 'companyId', $companyId );
		$company->users		= $users;
		$this->view->addData( 'company', $company );
		$this->view->addData( 'frontend', $this->frontend );
	}

	public function filter()
	{
		$this->messenger->noteSuccess( "Companies have been filtered." );
		$this->restart( './manage/company' );
	}

	public function index()
	{
		$this->addData( 'companies', $this->modelCompany->getAll() );
	}

	public function reject( $companyId )
	{
		$company	= $this->checkCompany( $companyId );
		$this->modelCompany->edit( $companyId, [
			'status'	=> -1,
			'modifiedAt' => time()
		] );
		$this->messenger->noteSuccess( 'Unternehmen "'.$company->title.'" abgelehnt.' );
		$this->restart( './manage/company' );
	}

	public function remove( $companyId )
	{
		$company	= $this->checkCompany( $companyId );
		$payload	= ['companyId' => $companyId];
		$this->env->getCaptain()->callHook( 'Company', 'remove', $this, $payload );
		if( $company->logo )
			@unlink( $this->frontend->getPath().'images/companies/'.$company->logo );
		$modelUser		= new Model_Company_User( $this->env );
		$modelUser->removeByIndex( 'companyId', $companyId );
		$this->modelCompany->remove( $companyId );
		$this->messenger->noteSuccess( 'Removed: '.$company->title );
		$this->restart( './manage/company' );
	}

	public function uploadLogo( $companyId )
	{
		$company	= $this->checkCompany( $companyId );
		$image		= $this->request->get( 'image' );
		try{
			$imagePath	= $this->frontend->getPath().'images/companies/';		//  @todo to configuration
			FolderEditor::createFolder( $imagePath, 0777 );
			$upload		= new Logic_Upload( $this->env );
			$upload->setUpload( $image );										//  @todo handle upload errors before
			if( !$upload->checkIsImage() )
				$this->messenger->noteError( 'Das ist kein Bild.' );
			else if( !$upload->checkSize( 1048576 ) )							//  @todo to configuration
				$this->messenger->noteError( 'Das Bild ist zu groß.' );
			else{
				$extension	= pathinfo( $image['name'], PATHINFO_EXTENSION );
				$imageName	= $companyId.'_'.md5( time() ).'.'.$extension;
				$upload->saveTo( $imagePath.$imageName );
				$image		= new Image( $imagePath.$imageName );
				$processor	= new ImageProcessing( $image );
				$size		= min( $image->getWidth(), $image->getHeight() );
				$offsetX	= (int) floor( ( $image->getWidth() - $size ) / 2 );
				$offsetY	= (int) floor( ( $image->getHeight() - $size ) / 2 );
				$processor->crop( $offsetX, $offsetY, $size, $size );
				$processor->scaleDownToLimit( 512, 512 );
				$image->save();
				$data	= array(
					'logo'			=> $imageName,
					'modifiedAt'	=> time()
				);
				if( $company->logo )
					unlink( $imagePath.$company->logo );
				$this->modelCompany->edit( $companyId, $data );
				$this->messenger->noteSuccess( 'Das Bild wurde hochgeladen und gespeichert.' );
			}
		}
		catch( Exception $e ){
			$this->messenger->noteError( 'Fehler: '.$e->getMessage() );
		}
		$this->restart( 'edit/'.$companyId, TRUE );
	}

	protected function __onInit(): void
	{
		$this->request			= $this->env->getRequest();
		$this->messenger		= $this->env->getMessenger();
		$this->frontend			= Logic_Frontend::getInstance( $this->env );
		$this->modelCompany		= new Model_Company( $this->env );
	}

	protected function checkCompany( $companyId )
	{
		$words		= (object) $this->getWords( 'msg' );
		$company	= $this->modelCompany->get( $companyId );
		if( !$company ){
			$this->messenger->noteFailure( $words->errorCompanyInvalid );
			$this->restart( NULL, TRUE );
		}
		return $company;
	}
}
