<?php
/**
 *	Model for storing downloadable files.
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@copyright		2014-2025 Ceus Media (https://ceusmedia.de/)
 */

use CeusMedia\HydrogenFramework\Model;

/**
 *	Model for storing downloadable files.
 *	@author			Christian Würker <christian.wuerker@ceusmedia.de>
 *	@copyright		2014-2025 Ceus Media (https://ceusmedia.de/)
 */
class Model_Download_File extends Model
{
	protected string $name			= 'download_files';

	protected array $columns		= [
		'downloadFileId',
		'downloadFolderId',
		'rank',
		'size',
		'title',
		'description',
		'nrDownloads',
		'uploadedAt',
		'downloadedAt'
	];

	protected string $primaryKey	= 'downloadFileId';

	protected array $indices		= [
		'downloadFolderId',
		'rank',
		'size',
		'title',
	];

	protected int $fetchMode		= PDO::FETCH_CLASS;

	protected ?string $className	= Entity_Download_File::class;
}
