<?php

use CeusMedia\HydrogenFramework\Model;

class Model_Stripe_Event extends Model
{
	public const STATUS_RECEIVED	= 0;
	public const STATUS_FAILED		= 1;
	public const STATUS_HANDLED		= 2;
	public const STATUS_CLOSED		= 3;

	public const STATUSES			= [
		self::STATUS_RECEIVED,
		self::STATUS_FAILED,
		self::STATUS_HANDLED,
		self::STATUS_CLOSED,
	];

	protected string $name			= 'stripe_events';

	protected array $columns		= [
		'eventId',
		'status',
		'id',
		'type',
		'output',
		'triggeredAt',
		'receivedAt',
		'handledAt',
	];

	protected string $primaryKey	= 'eventId';

	protected array $indices		= [
		'status',
		'id',
		'type',
	];

	protected int $fetchMode		= PDO::FETCH_OBJ;

	public array $types				= [
		'PAYIN_NORMAL'				=> ['PAYIN_NORMAL_CREATED', 'PAYIN_NORMAL_SUCCEEDED', 'PAYIN_NORMAL_FAILED'],
		'PAYOUT_NORMAL_'			=> ['PAYOUT_NORMAL_CREATED', 'PAYOUT_NORMAL_SUCCEEDED', 'PAYOUT_NORMAL_FAILED'],
		'TRANSFER_NORMAL'			=> ['TRANSFER_NORMAL_CREATED', 'TRANSFER_NORMAL_SUCCEEDED', 'TRANSFER_NORMAL_FAILED'],
		'PAYIN_REFUND'				=> ['PAYIN_REFUND_CREATED', 'PAYIN_REFUND_SUCCEEDED', 'PAYIN_REFUND_FAILED'],
		'PAYOUT_REFUND'				=> ['PAYOUT_REFUND_CREATED', 'PAYOUT_REFUND_SUCCEEDED', 'PAYOUT_REFUND_FAILED'],
		'TRANSFER_REFUND'			=> ['TRANSFER_REFUND_CREATED', 'TRANSFER_REFUND_SUCCEEDED', 'TRANSFER_REFUND_FAILED'],
		'PAYIN_REPUDIATION'			=> ['PAYIN_REPUDIATION_CREATED', 'PAYIN_REPUDIATION_SUCCEEDED', 'PAYIN_REPUDIATION_FAILED'],
		'KYC'						=> ['KYC_CREATED', 'KYC_SUCCEEDED', 'KYC_FAILED', 'KYC_VALIDATION_ASKED'],
		'DISPUTE_DOCUMENT'			=> ['DISPUTE_DOCUMENT_CREATED', 'DISPUTE_DOCUMENT_VALIDATION_ASKED', 'DISPUTE_DOCUMENT_SUCCEEDED', 'DISPUTE_DOCUMENT_FAILED'],
		'DISPUTE'					=> ['DISPUTE_CREATED', 'DISPUTE_SUBMITTED', 'DISPUTE_ACTION_REQUIRED', 'DISPUTE_FURTHER_ACTION_REQUIRED', 'DISPUTE_CLOSED', 'DISPUTE_SENT_TO_BANK'],
		'TRANSFER_SETTLEMENT'		=> ['TRANSFER_SETTLEMENT_CREATED', 'TRANSFER_SETTLEMENT_SUCCEEDED', 'TRANSFER_SETTLEMENT_FAILED'],
		'MANDATE'					=> ['MANDATE_CREATED', 'MANDATE_FAILED', 'MANDATE_ACTIVATED', 'MANDATE_SUBMITTED'],
		'PREAUTHORIZATION_PAYMENT'	=> ['PREAUTHORIZATION_PAYMENT_WAITING', 'PREAUTHORIZATION_PAYMENT_EXPIRED', 'PREAUTHORIZATION_PAYMENT_CANCELED', 'PREAUTHORIZATION_PAYMENT_VALIDATED'],
		'UBO_DECLARATION'			=> ['UBO_DECLARATION_CREATED', 'UBO_DECLARATION_VALIDATION_ASKED', 'UBO_DECLARATION_REFUSED', 'UBO_DECLARATION_VALIDATED'],
	];
}
