<?php

use CeusMedia\HydrogenFramework\Hook;

class Hook_Resource_User extends Hook
{
	/**
	 *	...
	 *	@access		public
	 *	@return		void
	 *	@throws		ReflectionException
	 *	@throws		\Psr\SimpleCache\InvalidArgumentException
	 */
	public function onUserRemove(): void
	{
		if( empty( $this->payload['userId'] ) )
			return;

		$modelUser		= new Model_User( $this->env );
		$modelPassword	= new Model_User_Password( $this->env );
		$modelGroupUser	= new Model_Group_User( $this->env );

		$modelPassword->removeByIndex( 'userId', $this->payload['userId'] );
		$modelGroupUser->removeByIndex( 'userId', $this->payload['userId'] );
		$modelUser->remove( $this->payload['userId'] );

		if( isset( $this->payload['counts'] ) )
			$this->payload['counts']['Resource_Users']	= (object) ['entities' => 1];
	}
}
