<?php

use CeusMedia\Common\ADT\Collection\Dictionary;
use CeusMedia\Mail\Address as MailAddress;
use CeusMedia\Mail\Address\Check\Availability as MailAvailabilityCheck;

class Job_Work_Mail_Check extends Job_Abstract
{
	protected Dictionary $options;

	/**
	 *	@return		void
	 *	@throws		ReflectionException
	 *	@throws		\Psr\SimpleCache\InvalidArgumentException
	 */
	public function run(): void
	{
		$modelAddress	= new Model_Mail_Check_Address( $this->env );
		$modelRun		= new Model_Mail_Check_Address_Run( $this->env );
		$sender			= new MailAddress( $this->options->get( 'sender' ) );
		$checker		= new MailAvailabilityCheck( $sender );
#		$checker->setVerbose( !TRUE );

		$conditions	= ['status' => 1];
		$orders		= ['address' => 'ASC'];
		$limits		= [0, $this->options->get( 'job.limit' )];
		$addresses	= $modelAddress->getAll( $conditions, $orders, $limits );
		foreach( $addresses as $address ){
			$this->out( "Checking: ".$address->address );
			try{
				$result		= $checker->test( new MailAddress( $address->address ) );
				$response	= $checker->getLastResponse();
				$modelRun->add( [
					'mailCheckAddressId'	=> $address->mailCheckAddressId,
					'status'				=> $result ? 1 : -1,
					'error'					=> $response->error,
					'code'					=> $response->code,
					'message'				=> $response->message,
					'createdAt'				=> time(),
				] );
				$status	= 2;
				if( !$result ){
					$status	= -2;
					if( str_starts_with( $response->code, "4" ) )
						$status	= -1;
				}
				$modelAddress->edit( $address->mailCheckAddressId, [
					'status'	=> $status,
					'checkedAt'	=> time(),
				] );
			}
			catch( Exception $e ){
				$modelRun->add( [
					'mailCheckAddressId'	=> $address->mailCheckAddressId,
					'status'				=> -2,
					'error'					=> NULL,
					'code'					=> $e->getCode(),
					'message'				=> $e->getMessage(),
					'createdAt'				=> time(),
				] );
				$modelAddress->edit( $address->mailCheckAddressId, [
					'status'	=> -2,
					'checkedAt'	=> time(),
				] );
			}
		}
		$this->out( 'Done checking '.count( $addresses ).' mail address(es)' );
	}

	protected function __onInit(): void
	{
		$this->options	= $this->env->getConfig()->getAll( 'module.work_mail_check.', TRUE );
	}
}
