<?php

use CeusMedia\HydrogenFramework\Entity;

class Entity_Work_Meeting extends Entity
{
	public int|string $meetingId			= 0;
	public int|string $creatorId			= 0;
	public int|string $jobScheduleIdRemind	= 0;
	public int|string $jobScheduleIdClose	= 0;
	public int $type						= Model_Work_Meeting::TYPE_GENERAL;
	public int $priority					= Model_Work_Meeting::PRIORITY_NORMAL;
	public int $status						= Model_Work_Meeting::STATUS_NEW;
	public string $dateStart;
	public string $dateEnd;
	public string $location;
	public string $title;
	public string $content;
	public string|NULL $link				= NULL;
	public int $createdAt;
	public int|NULL $modifiedAt				= NULL;

	/** @var Entity_Work_Meeting_Participant[] $participants */
	public array $participants				= [];

	protected static array $mandatoryFields	= [
		'dateStart',
		'dateEnd',
		'location',
		'title',
	];

	/**
	 *	@param		array		$array
	 *	@return		array
	 */
	protected static function presetStaticValues( array $array ): array
	{
		$array['createdAt']	= time();
		return $array;
	}
}
