<?php

use CeusMedia\HydrogenFramework\Environment;

class Logic_CustomerProject
{
	protected $env;
	protected static $instance		= NULL;
	protected $modelCustomer;
	protected $modelProject;
	protected $modelRelation;

	public static function getInstance( Environment $env )
	{
		if( !self::$instance )
			self::$instance	= new Logic_CustomerProject( $env );
		return self::$instance;
	}

	public function add( $customerId, $projectId, $type )
	{
		$session	= $this->env->getSession();
		return $this->modelRelation->add( array(
			'customerId'	=> $customerId,
			'projectId'		=> $projectId,
			'userId'		=> $session->get( 'auth_user_id' ),
			'type'			=> $type,
			'status'		=> 1,
			'createdAt'		=> time(),
		) );
	}

	public function getProjects( $customerId )
	{
		$list		= [];
		$relations	= $this->modelRelation->getAll( ['customerId' => $customerId] );
		foreach( $relations as $relation ){
			$relation->project	= $this->modelProject->get( $relation->projectId );
			$list[$relation->projectId]	= $relation;
		}
		return $list;
	}

	public function remove( $customerId, $projectId )
	{
		$relations	= $this->modelRelation->getAll( ['customerId' => $customerId, 'projectId' => $projectId] );
		foreach( $relations as $relation )
			$this->modelRelation->remove( $relation->customerProjectId );
		return count( $relations );
	}

	protected function __construct( Environment $env )
	{
		$this->env	= $env;
		$this->modelCustomer	= new Model_Customer( $env );
		$this->modelProject		= new Model_Project( $env );
		$this->modelRelation	= new Model_Customer_Project( $env );
	}

	protected function __clone()
	{
	}
}
