<?php

use CeusMedia\Common\Net\HTTP\Status as HttpStatus;
use CeusMedia\HydrogenFramework\Environment;
use CeusMedia\HydrogenFramework\Hook;

class Hook_IP_Lock extends Hook
{
	public static function onEnvInit( Environment $env, object $context, object $module, array & $payload )
	{
		$ip		= getEnv( 'REMOTE_ADDR' );																	//  get IP address of request
		$logic	= Logic_IP_Lock::getInstance( $env );														//  get instance of IP lock logic
		$logic->unlockIfOverdue( $ip, FALSE );																//  clear lock if existing and outdated
		$logic->applyFilters();																				//  apply filters on request of IP
		if( !$logic->isLockedIp( $ip ) )																	//  no lock is active for IP address
			return;
		$lock	= $logic->getByIp( $ip );																	//  get lock according to IP address
		$logic->countView( $lock->ipLockId );																//  count this error page view
		HttpStatus::sendHeader( $lock->reason->code );														//  send HTTP status code header
		header( 'Content-type: text/html; charset=utf-8' );													//  send MIME type header for UTF-8 HTML error page
		if( $lock->unlockIn > 0 )																			//  seconds to retry after are set
			header( 'Retry-After: '.$lock->unlockIn );														//  send retry header
		$retry		= $lock->unlockIn ? 'in '.$lock->unlockIn.' seconds' : '<em>never</em>';				//  render retry time
		$comment	= '<em>none</em>';																		//  assume empty reason description
		if( $lock->reason->description )																	//  reason has description
			$comment	= '<xmp>'.$lock->reason->description.'</xmp>';										//  render reason description
        $message    = '<h1>Access denied</h1><p>'.join( '<br/>', [										//  assemble HTML content
			'Access from your IP address is blocked.',														//  declare lock down
			'Reason: '.$lock->reason->title,																//  show lock reason title
			'Comment: '.$comment,																			//  show lock reason description
//				'Retry: '.$retry,																			//  show time to retry
		] ).'</p>';																							//  close paragraph
		print( $message );																					//  display error message
		exit;																								//  and quit application
	}
}
