-- phpMyAdmin SQL Dump
-- version 4.0.10deb1
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Erstellungszeit: 15. Mrz 2016 um 02:59
-- Server Version: 5.5.47-0ubuntu0.14.04.1
-- PHP-Version: 5.5.9-1ubuntu4.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

--
-- Datenbank: `sandbox_graph`
--
CREATE DATABASE IF NOT EXISTS `sandbox_graph` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;
USE `sandbox_graph`;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `graphs`
--

DROP TABLE IF EXISTS `graphs`;
CREATE TABLE IF NOT EXISTS `graphs` (
  `graphId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT 'digraph',
  `rankdir` varchar(3) COLLATE utf8_unicode_ci DEFAULT 'LR',
  `title` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `nodeShape` varchar(30) COLLATE utf8_unicode_ci DEFAULT 'box',
  `nodeStyle` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nodeColor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nodeFillcolor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nodeWidth` float DEFAULT NULL,
  `nodeHeight` float DEFAULT NULL,
  `nodeFontsize` float DEFAULT NULL,
  `nodeFontcolor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `edgeArrowhead` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `edgeArrowsize` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `edgeColor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `edgeFontcolor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `edgeFontsize` float DEFAULT NULL,
  `dot` text COLLATE utf8_unicode_ci,
  `image` longblob,
  `createdAt` decimal(12,0) NOT NULL,
  `modifiedAt` decimal(12,0) DEFAULT NULL,
  `renderedAt` decimal(12,0) DEFAULT NULL,
  PRIMARY KEY (`graphId`),
  KEY `type` (`type`),
  KEY `rankdir` (`rankdir`),
  KEY `title` (`title`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=3 ;

--
-- Daten für Tabelle `graphs`
--

INSERT INTO `graphs` (`graphId`, `type`, `rankdir`, `title`, `description`, `nodeShape`, `nodeStyle`, `nodeColor`, `nodeFillcolor`, `nodeWidth`, `nodeHeight`, `nodeFontsize`, `nodeFontcolor`, `edgeArrowhead`, `edgeArrowsize`, `edgeColor`, `edgeFontcolor`, `edgeFontsize`, `dot`, `image`, `createdAt`, `modifiedAt`, `renderedAt`) VALUES
(1, 'digraph', 'LR', 'Test Graph', 'This is just a test graph.', 'box', 'filled,rounded', '#AAAAAA', '#EFEFEF', NULL, NULL, 12, NULL, NULL, '0.5', '#AAAAAA', NULL, 10, 'digraph graph_1 {\n    rankdir="LR"\n    0 [shape="box" style="filled,rounded" color="#3377DD" fillcolor="#77AAFF" fontsize="12" width="" height="" label="Start"]\n    9 [shape="box" style="filled,rounded" color="#77DD77" fillcolor="#AAFFAA" fontsize="12" width="" height="" label="Ziel"]\n    5 [shape="box" style="filled" color="#AAAAAA" fillcolor="#EFEFEF" fontsize="12" width="" height="" label="Hauptlager"]\n    7 [shape="box" style="filled,rounded" color="#AAAAAA" fillcolor="#EFEFEF" fontsize="12" width="" height="" label="Versand"]\n\n    0->5 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="transport"]\n    5->9 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="einlagern"]\n    9->5 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="abgelehnt"]\n    5->5 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="prüfen"]\n    5->0 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="abgelehnt"]\n    5->7 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="vorbereiten"]\n    7->9 [arrowhead="" arrowsize="0.5" color="#AAAAAA" fontcolor="" fontsize="10" label="ausliefern"]\n}', 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, 0, NULL, 1458002284),
(2, 'digraph', 'LR', 'Graph #2', NULL, 'box', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'digraph graph_2 {\n    rankdir="LR"\n    0 [shape="box" style="" color="" fillcolor="" fontsize="" width="" height="" label="Start"]\n\n}', 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, 0, 1458005039, 1458005040);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `graph_edges`
--

DROP TABLE IF EXISTS `graph_edges`;
CREATE TABLE IF NOT EXISTS `graph_edges` (
  `edgeId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `graphId` int(10) unsigned NOT NULL,
  `fromNodeId` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `toNodeId` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `arrowhead` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `arrowsize` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fontcolor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fontsize` float DEFAULT NULL,
  PRIMARY KEY (`edgeId`),
  KEY `graphId` (`graphId`),
  KEY `fromNodeId` (`fromNodeId`),
  KEY `toNodeId` (`toNodeId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Daten für Tabelle `graph_edges`
--

INSERT INTO `graph_edges` (`edgeId`, `graphId`, `fromNodeId`, `toNodeId`, `label`, `arrowhead`, `arrowsize`, `color`, `fontcolor`, `fontsize`) VALUES
(1, 1, '1', '3', 'transport', NULL, NULL, NULL, NULL, NULL),
(2, 1, '3', '2', 'einlagern', NULL, NULL, NULL, NULL, NULL),
(3, 1, '2', '3', 'abgelehnt', NULL, NULL, NULL, NULL, NULL),
(4, 1, '3', '3', 'prüfen', NULL, NULL, NULL, NULL, NULL),
(5, 1, '3', '1', 'abgelehnt', NULL, NULL, NULL, NULL, NULL),
(6, 1, '3', '6', 'vorbereiten', '', '', '', '', 0),
(7, 1, '6', '2', 'ausliefern', '', '', '', '', 0);

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `graph_nodes`
--

DROP TABLE IF EXISTS `graph_nodes`;
CREATE TABLE IF NOT EXISTS `graph_nodes` (
  `nodeId` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `graphId` int(10) unsigned NOT NULL,
  `ID` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8_unicode_ci,
  `shape` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `style` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fillcolor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `width` float DEFAULT NULL,
  `height` float DEFAULT NULL,
  `fontsize` float DEFAULT NULL,
  `fontcolor` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`nodeId`),
  KEY `graphId` (`graphId`),
  KEY `ID` (`ID`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=8 ;

--
-- Daten für Tabelle `graph_nodes`
--

INSERT INTO `graph_nodes` (`nodeId`, `graphId`, `ID`, `label`, `description`, `shape`, `style`, `color`, `fillcolor`, `width`, `height`, `fontsize`, `fontcolor`) VALUES
(1, 1, '0', 'Start', 'Startzustand', NULL, NULL, '#3377DD', '#77AAFF', NULL, NULL, NULL, NULL),
(2, 1, '9', 'Ziel', NULL, NULL, NULL, '#77DD77', '#AAFFAA', NULL, NULL, NULL, NULL),
(3, 1, '5', 'Hauptlager', NULL, NULL, 'filled', NULL, NULL, NULL, NULL, NULL, NULL),
(5, 0, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(6, 1, '7', 'Versand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(7, 2, '0', 'Start', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
