<?php
class Controller_Manage_Ip_Lock_Transport extends CMF_Hydrogen_Controller{

	protected function __onInit(){
		$this->request			= $this->env->getRequest();
		$this->modelFilter		= new Model_IP_Lock_Filter( $this->env );
		$this->modelReason		= new Model_IP_Lock_Reason( $this->env );
	//	$this->logicTransport	= Logic_IP_Lock_Transport::getInstance();

		$logicPool				= $this->env->getLogic();
		$logicPoolKey			= $logicPool->getKeyFromClassName( 'Logic_IP_Lock_Transport' );
		$this->logicTransport	= $logicPool->get( $logicPoolKey );
	}

	public function index(){
		$reasons	= $this->modelReason->getAll( array(), array( 'title' => 'ASC' ) );
		$filters	= $this->modelFilter->getAll( array(), array( 'title' => 'ASC' ) );

		foreach( $reasons as $reason )
			$reason->filters	= $this->modelFilter->getAllByIndex(
				'reasonId',
				$reason->ipLockReasonId,
				array( 'title' => 'ASC'
			) );
		$this->addData( 'reasons', $reasons );
		$this->addData( 'filters', $filters );
	}


	public function export(){
		if( !$this->request->getMethod()->isPost() )
			$this->restart( NULL, TRUE );

		$fileName	= $this->request->get( 'filename' );
		$reasonIds	= $this->request->get( 'reasonIds' );
		$filterIds	= $this->request->get( 'filterIds' );

		if( $this->request->get( 'reasons' ) === 'all' )
			$reasonIds	= array();
		if( $this->request->get( 'filters' ) === 'all' )
			$filterIds	= array();
		$json		= $this->logicTransport->export( $reasonIds, $filterIds );

		if( !strlen( trim( $fileName ) ) )
			$fileName	= 'IP_lock_{DATE}';
		$fileName	= str_replace( '{DATE}', date( 'Y-M-D' ), $fileName );
		if( !preg_match( '/\.\S+$/', $fileName ) )
			$fileName	.= '.json';

		Net_HTTP_Download::sendString( $json, $fileName, TRUE );
	}

	public function import(){
		$request	= $this->env->getRequest();
		print_m( $this->env->getRequest()->getAll() );

		$upload	= new Logic_Upload( $this->env );
		try{
			$upload->setUpload( $request->get( 'upload' ) );
			if( !$upload->checkSize( '1MB' ) )
				throw new RuntimeException( 'Die Datei ist zu groß (max. 1MB)' );
			if( !$upload->checkExtension( array( 'json' ) ) )
				throw new RuntimeException( 'Die Datei muss eine JSON-Datei sein (endet auf <tt>.json</tt>)' );
			if( !$upload->checkMimeType( array( 'application/json' ) ) )
				throw new RuntimeException( 'Datei muss Daten im JSON-Format beinhalten.' );
			if( !$upload->getError() ){
				$data	= json_decode( $upload->getContent(), FALSE );
				$type	= $request->get( 'type' );
				switch( $type ){
					case 'fresh':
						$this->logicTransport->importFresh( $data );
						break;
					case 'merge':
						$this->logicTransport->importWithMerge( $data );
						break;
					default:
						throw new RangeException( 'Invalid import type: '.$type );
				}
			}
		}
		catch( Exception $e ){
			$this->env->getMessenger()->noteError( $e->getMessage().'.' );
		}
		$this->restart( NULL, TRUE );
	}
}
