<?php
$w			= (object) $words['index-filter'];

$iconFilter	= UI_HTML_Tag::create( 'i', '', array( 'class' => 'fa fa-fw fa-search' ) );
$iconReset	= UI_HTML_Tag::create( 'i', '', array( 'class' => 'fa fa-fw fa-search-minus' ) );

$buttonFilter	= UI_HTML_Tag::create( 'button', $iconFilter.'&nbsp;'.$w->buttonFilter, array(
	'type'	=> 'submit',
	'name'	=> 'filter',
	'class'	=> 'btn btn-info',
) );

$buttonReset	= UI_HTML_Tag::create( 'a', $iconReset.'&nbsp;'.$w->buttonReset, array(
	'href'	=> './manage/relocation/filter/reset',
	'class'	=> 'btn btn-small btn-inverse',
) );

$optStatus	= UI_HTML_Elements::Options( $words['states'], $filterStatus );

$optOrderColumn	= array(
	'title'			=> 'Titel',
	'views'			=> 'Klicks',
	'usedAt' 		=> 'Nutzung',
	'relocationId'	=> 'ID',
);
$optOrderColumn	= UI_HTML_Elements::Options( $optOrderColumn, $filterOrderColumn );

$optOrderDirection	= array(
	'asc' 	=> 'aufsteigend',
	'desc'	=> 'absteigend',
);
$optOrderDirection	= UI_HTML_Elements::Options( $optOrderDirection, $filterOrderDirection );

return '
		<div class="content-panel">
			<h3>'.$w->heading.'</h3>
			<div class="content-panel-inner">
				<form action="./manage/relocation/filter" method="post">
					<div class="row-fluid">
						<div class="span10">
							<label for="input_title">'.$w->labelTitle.'</label>
							<input type="text" name="title" id="input_title" class="span12" value="'.htmlentities( $filterTitle, ENT_QUOTES, 'UTF-8' ).'"/>
						</div>
						<div class="span2">
							<label for="input_id">'.$w->labelId.'</label>
							<input type="text" name="id" id="input_id" class="span12" value="'.htmlentities( $filterId, ENT_QUOTES, 'UTF-8' ).'"/>
						</div>
					</div>
					<div class="row-fluid">
						<div class="span12">
							<label for="">'.$w->labelStatus.'</label>
							<select name="status[]" id="input_status" multiple="multiple" class="span12">
								'.$optStatus.'
							</select>
						</div>
					</div>
					<div class="row-fluid">
						<div class="span6">
							<label for="input_orderColumn">'.$w->labelOrderColumn.'</label>
							<select name="orderColumn" id="input_orderColumn" class="span12">'.$optOrderColumn.'</select>
						</div>
						<div class="span6">
							<label for="input_orderDirection">'.$w->labelOrderDirection.'</label>
							<select name="orderDirection" id="input_orderDirection" class="span12">'.$optOrderDirection.'</select>
						</div>
					</div>
					<div class="buttonbar">
						'.$buttonFilter.'
						'.$buttonReset.'
					</div>
				</form>
			</div>
		</div>
';
