<?php
class Model_Mangopay_Event extends CMF_Hydrogen_Model {

	const STATUS_RECEIVED		= 0;
	const STATUS_FAILED			= 1;
	const STATUS_HANDLED		= 2;
	const STATUS_CLOSED			= 3;

	protected $name		= 'mangopay_events';
	protected $columns	= array(
		"eventId",
		"status",
		"id",
		"type",
		"output",
		"triggeredAt",
		"receivedAt",
		"handledAt",
	);
	protected $primaryKey	= 'eventId';
	protected $indices		= array(
		"status",
		"id",
		"type",
	);
	protected $fetchMode	= PDO::FETCH_OBJ;

	public $types			= array(
		'PAYIN_NORMAL'				=> array( 'PAYIN_NORMAL_CREATED', 'PAYIN_NORMAL_SUCCEEDED', 'PAYIN_NORMAL_FAILED' ),
		'PAYOUT_NORMAL_'			=> array( 'PAYOUT_NORMAL_CREATED', 'PAYOUT_NORMAL_SUCCEEDED', 'PAYOUT_NORMAL_FAILED' ),
		'TRANSFER_NORMAL'			=> array( 'TRANSFER_NORMAL_CREATED', 'TRANSFER_NORMAL_SUCCEEDED', 'TRANSFER_NORMAL_FAILED' ),
		'PAYIN_REFUND'				=> array( 'PAYIN_REFUND_CREATED', 'PAYIN_REFUND_SUCCEEDED', 'PAYIN_REFUND_FAILED' ),
		'PAYOUT_REFUND'				=> array( 'PAYOUT_REFUND_CREATED', 'PAYOUT_REFUND_SUCCEEDED', 'PAYOUT_REFUND_FAILED' ),
		'TRANSFER_REFUND'			=> array( 'TRANSFER_REFUND_CREATED', 'TRANSFER_REFUND_SUCCEEDED', 'TRANSFER_REFUND_FAILED' ),
		'PAYIN_REPUDIATION'			=> array( 'PAYIN_REPUDIATION_CREATED', 'PAYIN_REPUDIATION_SUCCEEDED', 'PAYIN_REPUDIATION_FAILED' ),
		'KYC'						=> array( 'KYC_CREATED', 'KYC_SUCCEEDED', 'KYC_FAILED', 'KYC_VALIDATION_ASKED' ),
		'DISPUTE_DOCUMENT'			=> array( 'DISPUTE_DOCUMENT_CREATED', 'DISPUTE_DOCUMENT_VALIDATION_ASKED', 'DISPUTE_DOCUMENT_SUCCEEDED', 'DISPUTE_DOCUMENT_FAILED' ),
		'DISPUTE'					=> array( 'DISPUTE_CREATED', 'DISPUTE_SUBMITTED', 'DISPUTE_ACTION_REQUIRED', 'DISPUTE_FURTHER_ACTION_REQUIRED', 'DISPUTE_CLOSED', 'DISPUTE_SENT_TO_BANK' ),
		'TRANSFER_SETTLEMENT'		=> array( 'TRANSFER_SETTLEMENT_CREATED', 'TRANSFER_SETTLEMENT_SUCCEEDED', 'TRANSFER_SETTLEMENT_FAILED' ),
		'MANDATE'					=> array( 'MANDATE_CREATED', 'MANDATE_FAILED', 'MANDATE_ACTIVATED', 'MANDATE_SUBMITTED' ),
		'PREAUTHORIZATION_PAYMENT'	=> array( 'PREAUTHORIZATION_PAYMENT_WAITING', 'PREAUTHORIZATION_PAYMENT_EXPIRED', 'PREAUTHORIZATION_PAYMENT_CANCELED', 'PREAUTHORIZATION_PAYMENT_VALIDATED' ),
		'UBO_DECLARATION'			=> array( 'UBO_DECLARATION_CREATED', 'UBO_DECLARATION_VALIDATION_ASKED', 'UBO_DECLARATION_REFUSED', 'UBO_DECLARATION_VALIDATED' ),
	);

}
?>
