<?php
class View_Helper_Work_Issue_ChangeNote
{
	const FORMAT_HTML		= 1;
	const FORMAT_TEXT		= 2;

	const FORMATS			= array(
		self::FORMAT_HTML,
		self::FORMAT_TEXT,
	);

	protected $env;
	protected $note;
	protected $format		= self::FORMAT_HTML;

	public function __construct( CMF_Hydrogen_Environment $env )
	{
		$this->env	= $env;
	}

	public function render(): string
	{
		if( $this->format === self::FORMAT_TEXT )
			return $this->renderAsText();
		return $this->renderAsHtml();
	}

	public function setFormat( int $format ): self
	{
		$this->format	= $format;
		return $this;
	}

	public function setNote( $note ): self
	{
		$this->note	= $note;
		return $this;
	}

	//  --  PROTECTED  --  //

	protected function renderAsHtml(): string
	{
		if( !$this->note )
			return '';

		$words		= $this->env->getLanguage()->getWords( 'work/issue' );

		$noteText	= '<em><small class="muted">Kein Kommentar.</small></em>';
		if( trim( $this->note->note ) ){
			if( $this->env->getModules()->has( 'UI_Markdown' ) )
				$noteText	= View_Helper_Markdown::transformStatic( $this->env, $this->note->note );
			else if( $this->env->getModules()->has( 'UI_Helper_Content' ) )
				$noteText	= View_Helper_ContentConverter::render( $this->env, $this->note->note );
			else
				$noteText	= nl2br( $this->note->note );
		}
		$note	= UI_HTML_Tag::create( 'tt', $noteText, array( 'class' => 'issue-change-list-note-content' ) );
		return $note;
	}

	protected function renderAsText(): string
	{
		if( !$this->note )
			return '';

		$words		= $this->env->getLanguage()->getWords( 'work/issue' );

		$noteText	= 'Kein Kommentar.';
		if( trim( $this->note->note ) )
			$noteText	= $this->note->note;
		return $noteText.PHP_EOL;
	}
}
